#ifndef _THREAD_H
#define _THREAD_H

#define INBUFSIZE 8192
#define OUTBUFSIZE 32000


typedef struct advstruct
{
	struct advstruct *next;
	int num;
	char descr[100];
	char author[80];
	char rating[20];
	char flags[20];
	char dir[40];
} ADV;

typedef struct eventstruct
{
	struct eventstruct *next;
	void *source;
	char text[200];
} EVENT;


class THREAD : public ParserIO
{
public:
	THREAD();
	virtual ~THREAD();
	int ioloop(char *,int *);
	int read_text(char *,int *);	// ParserIO callback method
	int write_text(char *,int ll = -1);
					// ParserIO callback method
	void echo_on();			// socket control (not used)
	void echo_off();		// socket control (not used)
	void add_event(char *s);	// node-node communication
	int catchup();			// node-node communication
	int get_adv();			// eol select adventure method

	// thread control
	THREAD *next;
	pthread_t thread;
	int running;			// thread keep-alive
	int socket;
	int ib,it,iq;
	int ob,ot,oq;
	char inbuf[INBUFSIZE];
	char outbuf[OUTBUFSIZE];

	// applesoft parser / eamon settings
	Parser cmdline;			// applesoft parse
	Account *account;		// db object: current account
	EVENT *current_event;		// current event pointer
	ADV *selected;			// selected eamon adventure disk
	int prompt_shown;
	int adjust_case;
	char last_print[1024];
	char prompt[200];		// last line of last_print
	char instr[1024];
};


#endif // _THREAD_H
